/**************************************************************
   RTTY DECODER for ARDUINO UNO
   2014.09.15 v2.2
   5BIT-BAUDOT-CODE, 45.45BAUD
   LCD 20x4 (UC-204)
/**************************************************************/

#include <LiquidCrystal.h>
#include <FlexiTimer2.h>

LiquidCrystal lcd(4,5,6,7,8,9,10);

boolean  dsp;
byte     ti;
uint8_t  baudot;

void timer_interrupt(void)
{
        static byte rSq;
        
        ti++;
        if(rSq == 0 && digitalRead(19) == 0)
        {
                rSq = 1;
                ti = 0;
        }
        if(rSq == 1 && ti == 10)
        {
                if(digitalRead(19) == 0)
                {
                        rSq = 2;
                        ti = 0;
                }
                else
                {
                        rSq = 0;
                }
        }
        if(rSq == 2 && ti == 22)
        {
                bitWrite(baudot, 0, digitalRead(19));
        }
        if(rSq == 2 && ti == 44)
        {
                bitWrite(baudot, 1, digitalRead(19));
        }
        if(rSq == 2 && ti == 66)
        {
                bitWrite(baudot, 2, digitalRead(19));
        }
        if(rSq == 2 && ti == 88)
        {
                bitWrite(baudot, 3, digitalRead(19));
        }
        if(rSq == 2 && ti == 110)
        {
                bitWrite(baudot, 4, digitalRead(19));
                dsp = 1;
        }
        if(rSq == 2 && ti == 135)
        {
                rSq = 0;
        }
}

void setup()
{
        lcd.begin(20, 4);
        lcd.clear();
        FlexiTimer2::set(1, timer_interrupt);
        FlexiTimer2::start();
}

void loop()
{
        static boolean fig;
        static byte    x;
        static byte    y;
        static char    ch;
        static char    c[61];
        int            i;
         
        if(dsp == 1)
        {
                ch = '\0';
                     if(baudot == B11111){fig = 0; } //LETTERS
                else if(baudot == B11011){fig = 1; } //FIGURES            
                else if(baudot == B01000){         } //CR
                else if(baudot == B00010){ch = ' ';} //LF
                else if(baudot == B00100){ch = ' ';} //SPACE
                if(fig == 0)
                {
                             if(baudot == B00011){ch = 'A';}
                        else if(baudot == B11001){ch = 'B';}
                        else if(baudot == B01110){ch = 'C';}
                        else if(baudot == B01001){ch = 'D';}
                        else if(baudot == B00001){ch = 'E';}
                        else if(baudot == B01101){ch = 'F';}
                        else if(baudot == B11010){ch = 'G';}
                        else if(baudot == B10100){ch = 'H';}
                        else if(baudot == B00110){ch = 'I';}
                        else if(baudot == B01011){ch = 'J';}
                        else if(baudot == B01111){ch = 'K';}
                        else if(baudot == B10010){ch = 'L';}
                        else if(baudot == B11100){ch = 'M';}
                        else if(baudot == B01100){ch = 'N';}
                        else if(baudot == B11000){ch = 'O';}
                        else if(baudot == B10110){ch = 'P';}
                        else if(baudot == B10111){ch = 'Q';}
                        else if(baudot == B01010){ch = 'R';}
                        else if(baudot == B00101){ch = 'S';}
                        else if(baudot == B10000){ch = 'T';}
                        else if(baudot == B00111){ch = 'U';}
                        else if(baudot == B11110){ch = 'V';}
                        else if(baudot == B10011){ch = 'W';}
                        else if(baudot == B11101){ch = 'X';}
                        else if(baudot == B10101){ch = 'Y';}
                        else if(baudot == B10001){ch = 'Z';}
                }
                if(fig == 1)
                {
                             if(baudot == B00011){ch = '-';}
                        else if(baudot == B11001){ch = '?';}
                        else if(baudot == B01110){ch = ':';}
                        else if(baudot == B01001){         }
                        else if(baudot == B00001){ch = '3';}
                        else if(baudot == B01101){         }
                        else if(baudot == B11010){         }
                        else if(baudot == B10100){         }
                        else if(baudot == B00110){ch = '8';}
                        else if(baudot == B01011){         }
                        else if(baudot == B01111){ch = '(';}
                        else if(baudot == B10010){ch = ')';}
                        else if(baudot == B11100){ch = '.';}
                        else if(baudot == B01100){ch = ',';}
                        else if(baudot == B11000){ch = '9';}
                        else if(baudot == B10110){ch = '0';}
                        else if(baudot == B10111){ch = '1';}
                        else if(baudot == B01010){ch = '4';}
                        else if(baudot == B00101){         }
                        else if(baudot == B10000){ch = '5';}
                        else if(baudot == B00111){ch = '7';}
                        else if(baudot == B11110){         }
                        else if(baudot == B10011){ch = '2';}
                        else if(baudot == B11101){ch = '/';}
                        else if(baudot == B10101){ch = '6';}
                        else if(baudot == B10001){         }
                }
                if(ch != '\0')
                {
                        lcd.print(ch);
                        if(y == 1){c[     x] = ch;}
                        if(y == 2){c[20 + x] = ch;}
                        if(y == 3){c[40 + x] = ch;}
                        x++;
                        if(x == 20 && y == 0){x = 0, y = 1;}
                        if(x == 20 && y == 1){x = 0, y = 2;}
                        if(x == 20 && y == 2){x = 0, y = 3;}
                        if(x == 20 && y == 3)
                        {
                                lcd.clear();
                                lcd.setCursor(0, 0); for(i = 0; i < 20; i++){lcd.print(c[     i]);}
                                lcd.setCursor(0, 1); for(i = 0; i < 20; i++){lcd.print(c[20 + i]);}
                                lcd.setCursor(0, 2); for(i = 0; i < 20; i++){lcd.print(c[40 + i]);}
                                x = 0, y = 3;
                                for(i = 0; i < 20; i++){c[     i] = c[20 + i];}
                                for(i = 0; i < 20; i++){c[20 + i] = c[40 + i];}
                        }
                        lcd.setCursor(x, y);
                }
                dsp = 0;
        }
        delay(5);
}

